------------------------------------------------------------------------------
-- Big City under Attack
------------------------------------------------------------------------------
function start1stChapter()

	-- Chests
	CreateChestOpener("Ari")
	CreateChestOpener("Mirai")
	CreateChestOpener("Dario")
	CreateChestOpener("Pilgrim")
	StartChestQuest()
	
	CreateChest(GetPosition("Chest"),openChest)
	
	-- Setup AI
	CreatePlayer2()
	CreatePlayer4()
	
	createArmyKadirCamp()
	
	CreateQuestMirai()
	CreateQuestKillFirstAttackers()
	
	burinngjob = StartSimpleHiResJob("ReplaceAlmostDeadBuildings")
	
	-- lost if hq destroyed
	AddDefeatEntity("HQ")
	AddDefeatEntity("DZ")
	
	--InitFog
	
	--Fog willl be enabled in cutscene
	CreateDynamicFog("LeftFog",0)
	
	CreateDynamicFog("MiddleFog", 0)
	CreateDynamicFog("RightFog", 0)

end
function end1stChapter()
	
	start2ndChapter()

end
------------------------------------------------------------------------------
-- Introduce Mirai and rescue city
------------------------------------------------------------------------------
function start2ndChapter()

	-- Create mirai entity and let her attack
	Attack(	CreateEntity(2, Entities.PU_Hero11, GetPosition("MiraiSpawn"), "Mirai"),
			"FirstAttackSpawn2")
	--MiraiID = GetID("Mirai")
	--MakeInvulnerable("Mirai")
		HPSave = 1000
	--MiraiHPTrigger = Trigger.RequestTrigger(Events.LOGIC_EVENT_ENTITY_HURT_ENTITY,nil,"MiraiHPCalc",1,nil,nil)
	--MiraiRegTrigger = Trigger.RequestTrigger(Events.LOGIC_EVENT_EVERY_SECOND,nil,"MiraiHPReg",1,nil,nil)
	
	--Logic.SetShareExplorationWithPlayerFlag(1,5,1)
	
	CreateBriefingMirai()
	CreateArmyMirai()	

	CreateQuestRescueCity()

end
function end2ndChapter()
	
	
	DZfound()
	Logic.SetPlayerPaysLeaderFlag(1, 1)
	CitywallsPlayercolor = true
	Display.SetPlayerColorMapping(3,PLAYER_COLOR)
	--MakeVulnerable("Mirai")
	Trigger.UnrequestTrigger(MiraiHPTrigger)
	Trigger.UnrequestTrigger(MiraiRegTrigger)

	-- Give player 2 to player 1
	Logic.ChangeAllEntitiesPlayerID(2, 1)
	EndJob(burinngjob)
	Logic.ChangeAllEntitiesPlayerID(6, 1)
	
	SetPlayerName(2, "")
	
	Logic.SetTechnologyState(4, Technologies.T_LeatherMailArmor, 3)
	Logic.SetTechnologyState(4, Technologies.T_ChainMailArmor, 3)
	Logic.SetTechnologyState(4, Technologies.T_PlateMailArmor, 3)
	Logic.SetTechnologyState(4, Technologies.T_SoftArcherArmor, 3)
	Logic.SetTechnologyState(4, Technologies.T_PaddedArcherArmor, 3)
	Logic.SetTechnologyState(4, Technologies.T_LeatherArcherArmor, 3)
	Logic.SetTechnologyState(4, Technologies.T_MasterOfSmithery, 3)
	Logic.SetTechnologyState(4, Technologies.T_IronCasting, 3)
	Logic.SetTechnologyState(4, Technologies.T_Fletching, 3)
	Logic.SetTechnologyState(4, Technologies.T_BodkinArrow, 3)
	Logic.SetTechnologyState(4, Technologies.T_WoodAging, 3)
	Logic.SetTechnologyState(4, Technologies.T_Turnery, 3)
	Logic.SetTechnologyState(4, Technologies.T_EnhancedGunPowder, 3)
	Logic.SetTechnologyState(4, Technologies.T_BlisteringCannonballs, 3)
	Logic.SetTechnologyState(4, Technologies.T_BetterTrainingBarracks, 3)
	Logic.SetTechnologyState(4, Technologies.T_BetterTrainingArchery, 3)
	Logic.SetTechnologyState(4, Technologies.T_Shoeing, 3)
	Logic.SetTechnologyState(4, Technologies.T_Masonry, 3)
	Logic.SetTechnologyState(4, Technologies.T_FleeceArmor, 3)
	Logic.SetTechnologyState(4, Technologies.T_FleeceLinedLeatherArmor, 3)
	Logic.SetTechnologyState(4, Technologies.T_LeadShot, 3)
	Logic.SetTechnologyState(4, Technologies.T_Sights, 3)
	Logic.SetTechnologyState(4, Technologies.T_BetterChassis, 3)
	
	StartSimpleJob("KadirCampDelay")
	
	CitywallsPlayercolor = true
	InitPlayerColorMapping()
	
	StartRuinMod()

	-- remove names
	SetPlayerName(2,nil)
	SetPlayerName(4,nil)

	-- change color of walls
	Display.SetPlayerColorMapping(3,PLAYER_COLOR)

	ResolveBriefing(briefingPreludeRescueCityQuest)
	ResolveBriefing(briefingPreludeShowIronMine)

	start3rdChapter()
	
end

------------------------------------------------------------------------------
-- Build up big city defense
------------------------------------------------------------------------------
function start3rdChapter()

	StartCutscene(Cutscenes[THRESHOLDONECUTSCENE],CreateBriefingDefend)

	CreateQuestBuildUpCity()

end
function end3rdChapter()

	start4thChapter()

end

------------------------------------------------------------------------------
-- First Attackers Wave appear
------------------------------------------------------------------------------
function start4thChapter()
	CreateEntity(8, Entities.PU_Thief, GetPosition("tiefspot"), "Sprenger")
	EnableNpcMarker("Sprenger")

	-- fog banks spawn together with army
	ChangeDynamicFog("MiddleFog", 7, 8)

	SetPlayerName(5, String.MainKey.."_Player4_2Name")
	--SetPlayerName(4,"Nebelvolk")
		
	CreateArmyAttackers()

	CreateBriefingAttackers()

	CreateQuestFirstAttackersWave()

end
function end4thChapter()
	
	Logic.ChangeAllEntitiesPlayerID(3, 1)
	wallchanged = true
	GUIQuestTools.ToggleStopWatch(300,1)
	CreateBriefingAttackersGone()
	--Message("@color:0,207,207 Diese Kreaturen werden bald versuchen die Stadt anzugreifen.")
	--StartSimpleJob("WaitSomeMinutes",5)
	StartSimpleJob("NextTickFunc")
	--start5thChapter()
	
end

function NextTickFunc()
	start5thChapter()
	return true
end

function WaitSomeMinutes(_time)
	if Counter.Tick2("WaitTime",_time*60) then
		start5thChapter()
		return true
	end
	return false
end
------------------------------------------------------------------------------
-- They will come back
------------------------------------------------------------------------------
function start5thChapter()

	-- fog banks spawn together with army
	ChangeDynamicFog("RightFog", 5, 8)
	ChangeDynamicFog("LeftFog", 6, 8)

	CreateArmyAttackers2()

	--CreateQuestDefend()

end
function end5thChapter()

	--Disable QuestInformation
	GUIQuestTools.DisableQuestInformation()
	FinalAttackComming = true
	--ResolveBriefing(briefingAttackersQuest)
	CreateBriefingThief2()
	--CreateBriefingRiflemen()
	InitWeatherGfxSets()
end
------------------------------------------------------------------------------
-- Destroy Nephilim
------------------------------------------------------------------------------
function start6thChapter()
	

	StartRain(60 * 100000)

	--CreateArmyFinalAttack()

	--AnSu: A cutscene will be startet thru this briefing. See briefing_finalAttack.lua
	CreateBriefingFinalAttack()

end
function end6thChapter()

	StartRain(1)
	
	StartCutscene(Cutscenes[MISSIONCOMPLETECUTSCENE],Victory)
	
	Logic.SetQuestType(1, 2, MAINQUEST_CLOSED, 0)

end

GameCallback_NPCInteraction = function(_heroId,_npcId)
	if IsBriefingActive() then
		return
	end
	if Logic.IsHero(_heroId) then
		
		if _npcId == GetEntityId("Sprenger") then
			if IsNear(_heroId,_npcId,BRIEFING_TALK_DISTANCE) then
				CreateBriefingThief()
			end
			
		end
	end
end

function DZfound()
	DZCheckerJob = StartSimpleJob("DZChecker")
end

function DZChecker()
	local _pos = GetPosition("DZseenPoint")
	local _IsHeroThere = Logic.IsPlayerEntityOfCategoryInArea(1, _pos.X, _pos.Y, 1200, "Hero")
	if _IsHeroThere == 1 then
		if not DZRuinFound then
			DZRuinFound = true
		end
		XGUIEng.ShowWidget("Movie",1)
		XGUIEng.ShowWidget("MovieBarTop",0)
		XGUIEng.ShowWidget("MovieBarBottom",0)
		XGUIEng.ShowWidget("CreditsWindowLogo",0)
		XGUIEng.ShowWidget("MovieInvisibleClickCatcher",0)
		XGUIEng.SetText("CreditsWindowTextTitle", "In Gedenken an Alt-Theley", 1)
		XGUIEng.SetText("CreditsWindowText", "Hier stand früher eine Burg gleichen Ausmaßes, wie jene von Theley. @cr @cr Von hier aus kann man die gesamte Region @cr überblicken @cr @cr Vielleicht erweist sich diese Ruine in @cr naher Zukunft noch als nützlich...", 1)
	else
		XGUIEng.ShowWidget("Movie",0)
	end
	return false
end